/**
  ******************************************************************************
  * @file    cp_frame.h 
  * @author  Ruediger R. Asche
  * @version V1.0.0
  * @date    July 14, 2016
  * @brief   include file for level 2 definitions of the sample communication protocol
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, THE AUTHOR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  ******************************************************************************  
  */ 


#ifndef CP_PRIQUEUE_H
#define CP_PRIQUEUE_H

typedef enum
{
    CP_PRIQUEUE_CRITICALPRI = 0,
    CP_PRIQUEUE_MEDIUMPRI,
    CP_PRIQUEUE_LOWPRI,  
    CP_PRIQUEUE_MAXPRIORITIES
} CP_PRILEVELS;

#define CP_NOQUEUE (CP_PRILEVELS) -1

typedef struct CP_PRIQUEUE
{
    xSemaphoreHandle m_Mutex;
    xQueueHandle m_Queues[CP_PRIQUEUE_MAXPRIORITIES];
    CP_PRILEVELS m_QueueCurrentlySending;
} CP_PRIQUEUE, *PCP_PRIQUEUE;

typedef PCP_PRIQUEUE CP_PRIQUEUEHANDLE;

extern CP_STATUSCODE CP_CreatePriQueue(CP_PRIQUEUEHANDLE *p_QueueHandle);
extern CP_STATUSCODE CP_DeletePriQueue(CP_PRIQUEUEHANDLE p_QueueHandle);
extern CP_STATUSCODE CP_SendPriQueue(CP_PRIQUEUEHANDLE p_QueueHandle,CP_PRILEVELS p_QueueIndex,void *p_ItemToQueue);
extern CP_STATUSCODE CP_PeekPriQueue(CP_PRIQUEUEHANDLE p_QueueHandle,void *p_ItemToPeek,CP_PRILEVELS *p_Pri);
extern CP_STATUSCODE CP_RemovedPeekedPriQueue(CP_PRIQUEUEHANDLE p_QueueHandle,CP_PRILEVELS p_Pri);

extern          void CP_BeginAtomic(CP_PRIQUEUEHANDLE p_QueueHandle);
extern          void CP_EndAtomic(CP_PRIQUEUEHANDLE p_QueueHandle);

#endif

